% Section 4.6.2 Performance of FE and FTC 
% 29/02/2020, Jianglin Lan
% This is the main file to simulate the closed-system, by automatically calling files below:
% "Closed_sys_performance.m", "Draw_figures2.m"
% Note: To generate results of baseline controller (in Fig.4.6) and FTC controller (in
% Figs.4.4, 4.5 & 4.7), select the corresponding controller in "Closed_sys_performance.m"
close all
clear
clc

% System parameters
A = [    0         0    1.0000         0         0
         0   -0.1540   -0.0042    1.5400         0
         0    0.2490   -1.0000   -5.2000         0
    0.0386   -0.9960   -0.0003   -0.1170         0
         0    0.5000         0         0   -0.5000];
     
B = [    0         0
   -3.7200   -0.1600
    1.6850   -5.6000
    0.1000         0
         0         0]; 
     
F = [    0
   -3.7200
    1.6850
    0.1000
         0];
     
D = [0 0;1 1;0 1;1 0;0 0];

C = [0 1 0 0 0;0 0 0 1 1;1 1 1 0 0];  

[n,m] = size(B);
[~,q] = size(F);
[~,l] = size(D);
[p,~] = size(C);

% Uncertainty
Ap = [   0         0         0         0         0
         0   -0.1540   -0.0042    1.5400         0
         0    0.2490   -1.0000   -5.2000         0
    0.0386   -0.9960   -0.0003   -0.1170         0
         0    0.5000         0         0   -0.5];
Mc = eye(n);
Nc = 0.05*Ap;
Delta_A = Mc*Nc;

% Augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];

% Controller & observer gains
load('K.mat');
load('N.mat');
load('G.mat');
load('L.mat');
load('H.mat');

% Define global variables to store data
global tmp count ts ex1 ex2 ex3 ex4 ex5 ef ff
tmp = 0; count = 0; ts = []; ex1 = []; ex2 = []; ex3 = []; ex4 = []; ex5 = []; ef = []; ff = [];

% Initial conditon
x0 = [0.5 0 0.5 0 0];
hat_Xf0 = zeros(1,n+2*q);
xx0 = [x0 hat_Xf0];

% Simulation time span
t0 = 0;
tf = 250;
tspan = [t0 tf];

% Solve differential equation
[tt,sys] = ode45(@(t,xx) Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,N,G,L,H), tspan, xx0);
x1 = sys(:,1);
x2 = sys(:,2);
x3 = sys(:,3);
x4 = sys(:,4);
x5 = sys(:,5);
hat_f = sys(:,11);

% Draw figures
run('Draw_figures2.m');